function [central_Moments_reshaped] = central_Moments_fun(FP_BF_im,max_order)

% max_order = 7; % for Firing Pin Impression
% max_order = 14; % for Breech Face Region
% max_order =16; % for Entire ROI


% plot_title = false;
% plot_export = false;

%% Estimate the Central Moment Polynomials
scale_moment = true;

circle_moments = false;

%x = -1:0.001:1;
F=FP_BF_im;
F1 = -1 + 2.*(F - min(F(:)))./(max(F(:)) - min(F(:)));
% rescale F to make all points lie in range 0 and 1

L = size(F1,1)-1;
x = (-L:2:L)/L;
[X,Y] = meshgrid(x);

background_color = '#BCBCE0';
azel = [-22.5 22.5];


%[X,Y] = meshgrid(x,x);
[theta,r] = cart2pol(X,Y);
II_exclude = r>1;

is_in_circle=~II_exclude;

Z=nan(size(X));

central_Moments = zeros([max_order+1, max_order+1]);
central_Moments1 = zeros([max_order+1, max_order+1]);

for I_1 = 0:max_order
    z1 = x.^I_1;
    if circle_moments
        z1 = abs(z1);
    end
    for I_2 = 0:max_order
        z2 = x.^I_2;
        if circle_moments
            z2 = abs(z2);
        end
        
        Z = z1'*z2;
        Z(II_exclude) = NaN;
        
        if scale_moment
            Z = Z./(max(Z(:)));
        end
     
        Moment=F1(is_in_circle).*Z(is_in_circle); %Moment and Moment 2 give the same value
        %Moment2=F1.*Z;
        central_Moments(I_1+1,I_2+1)= nansum(Moment(:)); % Multiplication
        
    % Using the least squares method to obtain the moments
%         F1_reshaped = reshape(F1,[(L+1)*(L+1),1]);
%         Z_reshaped= reshape(Z,[(L+1)*(L+1),1]);
%         Z_reshaped(isnan(Z_reshaped))=0;
%         %Moment1=(Z_reshaped.'*Z_reshaped)^-1*(Z_reshaped.'*F1_reshaped);
%         Moment1=Z_reshaped(is_in_circle)\F1_reshaped(is_in_circle);
%         central_Moments1(I_1+1,I_2+1)= Moment1;
    end
end
% the Projection
central_Moments_reshaped = reshape(central_Moments, [1 (max_order+1)*(max_order+1)]);
%the Least squared
%central_Moments1_reshaped = reshape(central_Moments1, [1 (max_order+1)*(max_order+1)]);
%
